<?php
// Bu dosya, Zaman Makinesi'nden gelen tarihi session'a kaydeder.
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['new_date'])) {
    $new_date_str = $_POST['new_date'];

    // Gelen tarihi doğrula ve formatla
    $date = DateTime::createFromFormat('d-m-Y H:i', $new_date_str);
    if ($date) {
        // Yeni tarihi session'a kaydet
        $_SESSION['simulated_time'] = $date->format('Y-m-d H:i:s');

        // Başarılı olduğuna dair JSON cevabı döndür
        header('Content-Type: application/json');
        echo json_encode(['success' => true, 'message' => 'Sistem zamanı güncellendi.']);
        exit();
    }
}

// Başarısız olursa hata mesajı döndür
header('Content-Type: application/json');
http_response_code(400); // Bad Request
echo json_encode(['success' => false, 'message' => 'Geçersiz tarih formatı.']);
?>